/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.network;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.objects.container.CapabilityContainerListener;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

@ParametersAreNonnullByDefault
public class PacketCapabilityContainerUpdate
implements IMessage {
    private final TIntObjectMap<NBTTagCompound> capabilityData = new TIntObjectHashMap();
    private int windowID;

    @Deprecated
    public PacketCapabilityContainerUpdate() {
    }

    public PacketCapabilityContainerUpdate(int windowID, int slotID, ItemStack stack) {
        this.windowID = windowID;
        NBTTagCompound data = CapabilityContainerListener.readCapabilityData(stack);
        if (!data.func_82582_d()) {
            this.capabilityData.put(slotID, (Object)data);
        }
    }

    public PacketCapabilityContainerUpdate(int windowID, NonNullList<ItemStack> items) {
        this.windowID = windowID;
        for (int i = 0; i < items.size(); ++i) {
            NBTTagCompound nbt = CapabilityContainerListener.readCapabilityData((ItemStack)items.get(i));
            if (nbt.func_82582_d()) continue;
            this.capabilityData.put(i, (Object)nbt);
        }
    }

    public final void fromBytes(ByteBuf buf) {
        this.windowID = buf.readInt();
        int numEntries = buf.readInt();
        for (int i = 0; i < numEntries; ++i) {
            int index = buf.readInt();
            NBTTagCompound data = ByteBufUtils.readTag((ByteBuf)buf);
            this.capabilityData.put(index, (Object)data);
        }
    }

    public final void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowID);
        buf.writeInt(this.capabilityData.size());
        this.capabilityData.forEachEntry((index, data) -> {
            buf.writeInt(index);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)data);
            return true;
        });
    }

    public final boolean hasData() {
        return !this.capabilityData.isEmpty();
    }

    @ParametersAreNonnullByDefault
    public static class Handler
    implements IMessageHandler<PacketCapabilityContainerUpdate, IMessage> {
        public IMessage onMessage(PacketCapabilityContainerUpdate message, MessageContext ctx) {
            if (!message.hasData()) {
                return null;
            }
            TerraFirmaCraft.getProxy().getThreadListener(ctx).func_152344_a(() -> {
                EntityPlayer player = TerraFirmaCraft.getProxy().getPlayer(ctx);
                if (player != null) {
                    Container container;
                    if (message.windowID == 0) {
                        container = player.field_71069_bz;
                    } else if (message.windowID == player.field_71070_bA.field_75152_c) {
                        container = player.field_71070_bA;
                    } else {
                        return;
                    }
                    message.capabilityData.forEachEntry((index, nbt) -> {
                        CapabilityContainerListener.applyCapabilityData(container.func_75139_a(index).func_75211_c(), nbt);
                        return true;
                    });
                }
            });
            return null;
        }
    }
}

